require('dotenv').config()

const knex = require('knex')({
    client: 'mysql',
    connection: {
        host: process.env.DBHOST,
        user: process.env.DBUSER,
        password: process.env.DBPASS
    }
})

knex.raw(`Create Database ${process.env.DBNAME}`).then(function (res) {
    console.log(`Database Create Successful: ${process.env.DBNAME}`);
}).catch(error => {
    console.log(error.sqlMessage);
}).finally(() => {
    knex.destroy();
});